

% Steering Control Algorithm for a certain shapes using the Directed Method
% (DM)

% Steps as the following:
% 1- Hardware & Software Initialization ( Camera, NI box, required variables ).
% 2- Measure position error (vibrational noise).
% 3- Determine shape Points ( snap image, select positions, save data).
% 4- Measurement of lateral frequencies ( examine all available modes ).
% 5- Apply best lateral frequency.
% 6- Target condition ( if yes end the process, else Go to step 4 ).
% 7- Repeat the above steps if multi-target is required (e.g.square shape).

%%%%%%%%%%%%%%   Step 1:Initialization part   %%%%%%%%%%%%%%%%%%%%%%%%%%%%

[X_EST,Y_EST,X_Real,Y_Real,MWP,Total_time,x,y,FM,SELC_D,REQ_D,All_Dir,t,core,NI_daq_session,Step_disp...
    ,delta,PZT_num,PZT_NUM,All_Step_disp,P_E,T_m,FAILED_TST,CELLS,XY_ERR,fm_Tst_t...
    ,Tm,X_tst,Y_tst,PRCNTG_E,Failed_tst,Save_Cells,Min_Thresh_Max,Tst_t,FM_both,FM_BOTH,...
    Pred_Disp,XYF_LEARN,fail_point,XYF_learn,NoTst,new_stage,Count_dist,X_d,Y_d,Actual_disp,DECISION_NUM]= Initialization5Modes();

%%%%%%%%%%%%%%   Step 2: Measure position error %%%%%%%%%%%%%%%%%%%%%%%%%%
[Postion_Err,File_N]=Position_Err15(NI_daq_session,core);

%%%%%%%%%%%%%%   Step 3: determine shape Points %%%%%%%%%%%%%
[X(1),Y(1),Shape_Pts,Shift,Shape_stp]=Steering_Shape_Points(core,File_N);
if Shape_stp > 1
scatter(Shape_Pts(:,1),Shape_Pts(:,2))% plot the shape points on the real time manipulation screen.
end
x = [x,X(1)]; y = [y,Y(1)]; % save the start position coordination

for stage=1:Shape_stp
%%%%%%%%% Shape Loop %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
X_final=Shape_Pts(stage,1);
Y_final=Shape_Pts(stage,2);

%%%%%%%%%%%%%%  Step 4: the main steering loop %%%%%%%%%%%%%%%%%%%%
% loop until particle arrive to the final destination 
for i=1:inf % attempts number to reach the target 
MWP=MWP+1;  % increase attempts number
if NoTst==0 % if DM is not applied for the next step.
[PZT_num]=PZT_Config(X(i),Y(i),X_final,Y_final);% determine PZT configuration for the measurement stage.
end

%%%% Applying number of lateral modes for only short time and determine best frequency to apply  %%%

[Step_disp,delta,X_tst,Y_tst,T,X_est,Y_est,PZT_num,Req_dir,PRCNTG_E,Tm,freq,Selc_dir,Tst_t,Min_Thresh_Max,Failed_tst,Save_Cells,XY_err,fm_Tst_t,Pred_Disp,Decision_num]...
    =Testing_FMs_DM(NI_daq_session,i,core,X,Y,File_N,X_final,Y_final,Postion_Err,PZT_num,fm_Tst_t,delta,Tm,Step_disp,X_tst,Y_tst,PRCNTG_E,Failed_tst,Save_Cells,Min_Thresh_Max,Tst_t,...
    Pred_Disp,XYF_learn,fail_point,NoTst);

%%%%%%%%%% step 5: Apply best frequency %%%%%%%%%%%%%% 
 
    [X(i+1),Y(i+1)]=Apply_best_FM13(NI_daq_session,T,fm,PZT_num,core,i,X_est,Y_est,File_N);
    T=[T 0];fm=[fm 0];Selc_dir=[Selc_dir 0];FM_both=0;% all of these matrix have to be saved in n x 2 diminsion


Disp= sqrt((Y(i+1)-Y(i))^2+(X(i+1)-X(i))^2);% calculate of shifted displacement
Actual_disp=[Actual_disp Disp];Total_Dist=sum(Actual_disp);% accumulation of all shifted displacements
Real_Dir= wrapTo2Pi(atan2((Y(i+1)-Y(i)),(X(i+1)-X(i)))); % calculate of shifted direction
%%% calculate target distance
Delta_x=X_final-X(i+1);Delta_y=Y_final-Y(i+1);
Destination=sqrt(Delta_x^2+Delta_y^2);
%%%%%%%%%%%%%   DM for the next step %%%%%%%%%%%
if   Disp < 50 && Count_dist < 50 && Destination > 50 %% 3 conditions for applying DM for the next step.
    T(2)=[];fm(2)=[];Selc_dir(2)=[];
    Dir_def=abs(wrapToPi(Real_Dir-Selc_dir));
    if  Dir_def > 0.1 % considering only bad direction (not magnitude) to update forces.
        fail_point=1;
    else 
        fail_point=0;
    end
    XYF_learn=[i X(i) Y(i) Disp(1) Real_Dir T(1) fm(1) fail_point];
    XYF_LEARN=[XYF_LEARN; XYF_learn];% accumulation of learning matrix.
    T=[T(1) 0];fm=[fm(1) 0];Selc_dir=[Selc_dir(1) 0];% all of these matrix have to be saved in n x 2 diminsion
    NoTst=1;% no forces measurement for the next step.
    Count_dist=Count_dist+Disp;% accumulated shifted distance.
    LM=1;
else % DM not applied next step. ( normal step )
    NoTst=0;Count_dist=0;LM=0;
    fail_point=0;
    T=[T(1) 0];fm=[fm(1) 0];Selc_dir=[Selc_dir(1) 0];% all of these matrix have to be saved in n x 2 diminsion
end

%%%%%%%%%% all matrices accumulation %%%%%%%%%%%%%%%%%%%%%%
[X_EST,Y_EST,FM,SELC_D,REQ_D,All_Dir,t,Total_time,X_Real,Y_Real,PZT_NUM,All_Step_disp...
     ,P_E,T_m,FAILED_TST,CELLS,XY_ERR]=Matrix_acc15(X_est,Y_est,fm,Selc_dir,Req_dir,delta,T,X_EST,...
     Y_EST,FM,SELC_D,REQ_D,All_Dir,t,Total_time,X_Real,Y_Real,PZT_num,PZT_NUM,Step_disp,PRCNTG_E,...
     P_E,All_Step_disp,X_tst,Y_tst,T_m,Tm,Failed_tst,FAILED_TST,CELLS,Save_Cells,XY_ERR,XY_err,...
     DECISION_NUM,Decision_num,FM_BOTH ,FM_both);
 
%%%%%%%%%% Step 6: Target condition %%%%%%%%%%%%%%%%%%%%%%%
[cur_pos_error,x,y]=Target_condition(x,y,X(i+1),Y(i+1),X_final,Y_final);

% This only to correct next target position if manipulating shapes. 
 X_d= X_final-X(i+1); Y_d= Y_final-Y(i+1);  
 
 Target_Dist =sqrt((Y_final-y(1))^2+(X_final-x(1))^2);
if cur_pos_error <= 20 % accuracy of hitting the target. 
 
 % this executes if reach the target.( true if condition )
 End_Fun(X(i+1),Y(i+1),X_final,Y_final,MWP,Total_time,Total_Dist,Target_Dist)% printing final parametric results
break;% finish the manipulation loop if target is reached.

else% continue the manipulation loop if target is not reached.
    
end % condition to reach target
end % number of attempts to reach target

%%%%%%%%%%%%   save all data %%%%%%%%%%%%%%%
    Save_data16(X_Real,Y_Real,X_EST,Y_EST,t,FM,x,y,SELC_D,REQ_D,All_Dir,X_final,Y_final,...
    File_N,PZT_NUM,All_Step_disp,Postion_Err,P_E,T_m,MWP,Min_Thresh_Max,FAILED_TST,CELLS,XY_ERR,fm_Tst_t,...
    FM_BOTH,Pred_Disp,XYF_LEARN,Total_Dist,Target_Dist,DECISION_NUM)

if Shape_stp > 1 %%% lower part is designed for shapes 
    % assign new file number and first position for the next stage (first stage is excluded from this assignment)
    File_N=(File_N)+1;
    X(1)=X(i+1);
    Y(1)=Y(i+1);
    
    % save the last image from the last stage as the first image for next stage
    img= imread(['F:\SteeringControl\Steer (',num2str((File_N)-1),')\img(',num2str(i+1),').jpg']);
    imwrite(img,['F:\SteeringControl\Steer (',num2str(File_N),')\img(1).jpg']);

    %%%%%% new stage initilazation %%%%%%
   
        [X_EST,Y_EST,X_Real,Y_Real,MWP,Total_time,x,y,FM,SELC_D,REQ_D,All_Dir,t,Step_disp...
    ,delta,PZT_num,PZT_NUM,All_Step_disp,P_E,T_m,FAILED_TST,CELLS,XY_ERR,fm_Tst_t...
    ,Tm,X_tst,Y_tst,PRCNTG_E,Failed_tst,Save_Cells,Min_Thresh_Max,Tst_t,FM_both,FM_BOTH,...
    Pred_Disp,XYF_LEARN,fail_point,XYF_learn,NoTst,new_stage,Count_dist,X_d,Y_d,Actual_disp...
    ,DECISION_NUM]= Initialization_5Modes_stage();
    
    x = [x,X(1)];y = [y,Y(1)]; % save the last position from the last stage as the first position for next stage.
end 
end 

